implementation module DynamicLinkerInterface

import StdEnv

import EnDecode
import DefaultElem
import DynamicUtilities

from StdDynamicLowLevelInterface import RID_N_TYPE_TABLES_OFFSET
import StdDynamicLowLevelInterface
import shared_buffer
import memory_mapped_files
from _SystemDynamic import ::T_ypeID(..), ::EncodedDynamic(..)
import code from "read_function.obj"

// -------------------------------------------------------------------------------------------
// communication between application and client
:: TypeReference
	= {
		tr_type_name	:: !String
	,	tr_module_name1	:: !String
	,	tr_module_name2	:: !String
	,	tr_library1		:: !LibraryID
	,	tr_library2		:: !LibraryID
	}

instance DefaultElem TypeReference
where
	default_elem 
		 = {
			tr_type_name	= {}
		,	tr_module_name1	= {}
		,	tr_module_name2	= {}
		,	tr_library1		= default_elem
		,	tr_library2		= default_elem
		}

instance EnDecode TypeReference
where
	to_size {tr_type_name,tr_module_name1,tr_module_name2,tr_library1,tr_library2}
		= to_size tr_type_name + to_size tr_module_name1 + to_size tr_module_name2 + to_size tr_library1 + to_size tr_library2
		
	to_string {tr_type_name,tr_module_name1,tr_module_name2,tr_library1,tr_library2} offset buffer
		# (offset,buffer)
			= to_string tr_type_name offset buffer
		# (offset,buffer)
			= to_string tr_module_name1 offset buffer
		# (offset,buffer)
			= to_string tr_module_name2 offset buffer
		# (offset,buffer)
			= to_string tr_library1 offset buffer
		# (offset,buffer)
			= to_string tr_library2 offset buffer
		= (offset,buffer)
			
	from_string offset buffer
		# (tr_type_name,offset)
			= from_string offset buffer
		# (tr_module_name1,offset)
			= from_string offset buffer
		# (tr_module_name2,offset)
			= from_string offset buffer
		# (tr_library1,offset)
			= from_string offset buffer
		# (tr_library2,offset)
			= from_string offset buffer
			
		# type_ref
			= { 
				tr_type_name 	= tr_type_name
			,	tr_module_name1	= tr_module_name1
			,	tr_module_name2	= tr_module_name2
			,	tr_library1		= tr_library1
			,	tr_library2		= tr_library2
			}
		= (type_ref,offset)
	
:: LibraryID
	= Address !Int
	| Number !Int				// always RunTime valid (kan geen diskID zijn)
		
	
instance DefaultElem LibraryID
where
	default_elem 
		= Address 0

ENDECODE_LIBRARYID_SIZE	:== 1
ENDECODE_ADDRESS 	:== 0
ENDECODE_NUMBER		:== 1

instance EnDecode LibraryID
where
	to_size (Address i)
		= ENDECODE_LIBRARYID_SIZE + to_size i
	to_size (Number i)
		= ENDECODE_LIBRARYID_SIZE + to_size i
	
	to_string x=:(Address i) offset buffer 	
		# buffer
			= { buffer & [offset] = toChar ENDECODE_ADDRESS }
	    = (offset + to_size x, WriteLong buffer (offset + ENDECODE_LIBRARYID_SIZE) i)
	    
	to_string x=:(Number i) offset buffer 	
		# buffer
			= { buffer & [offset] = toChar ENDECODE_NUMBER }
	    = (offset + to_size x, WriteLong buffer (offset + ENDECODE_LIBRARYID_SIZE) i)
	
	from_string offset buffer	
		# library_id
			= buffer.[offset]
		# i
			= FromStringToInt buffer (offset + ENDECODE_LIBRARYID_SIZE)
		# library_id
			= toInt library_id
		| library_id == ENDECODE_ADDRESS
			#! x = Address i
			= (x, offset + to_size x)
		| library_id == ENDECODE_NUMBER
			#! x = Number i
			= (x, offset + to_size x)

CheckTypeDefinitions :: ![TypeReference] -> Bool
CheckTypeDefinitions []
	= True
CheckTypeDefinitions type_refs
	= decode (doreqS ("CheckTypeDefinitions" +++ encode type_refs))

// -------------------------------------------------------------------------------------------
:: *RegisterLazyDynamic_Out
	= {
		rld_o_file							:: !*(!Int,!*StdDynamicSharedBufferInfo) //!(!Int,!Int)
	,	rld_o_filename						:: !String
	,	rld_o_diskid_to_runtimeid			:: !{#Int}			// conversion from DiskId (disguished as RunTimeId) to *real* runtimeID (library instances)
	,	rld_o_disk_to_rt_dynamic_indices	:: !{#Int} 			// conversion from disk to runtime index for lazy dynamics
	,	rld_o_id							:: !Int
	,	rld_o_rt_type_redirection_table		:: !{#RunTimeIDW}	
	
	}
// Decode
RegisterLazyDynamic :: !Int -> RegisterLazyDynamic_Out
RegisterLazyDynamic lazy_dynamic_index
	#! msg
		= "RegisterLazyDynamic" +++ (encode lazy_dynamic_index) +++
			"\n"
	#! s_adr
		= doreqS msg

	#! ((file,file_name),j)
		= from_string  0 s_adr

	#! (diskid_to_runtimeid,j)
		= from_string j s_adr
	#! (di_disk_to_rt_dynamic_indices,j)
		= from_string j s_adr

//	#! s_adr
//		= s_adr % (j,dec (size s_adr))
//	# id = FromStringToInt s_adr j //0
	
	# (id,j)
		= from_string j s_adr;
	# (type_redirection_table,j)
		= from_string j s_adr;	
	
	# (ok,rld_o_file)
		= OpenExistingSharedBuffer2 file
	| not ok
		= abort "RegisterLazyDynamic: OpenExistingSharedBuffer failed"
		
	#! rld
		= { 
			rld_o_file							= rld_o_file
		,	rld_o_filename						= file_name
		,	rld_o_diskid_to_runtimeid			= diskid_to_runtimeid
		,	rld_o_disk_to_rt_dynamic_indices	= di_disk_to_rt_dynamic_indices
		,	rld_o_id							= id
		,	rld_o_rt_type_redirection_table		= type_redirection_table
		}
	= rld

// -------------------------------------------------------------------------------------------
:: GetBlockAddress_In
	= {
		gba_i_filename				:: !String
	,	gba_i_first_time			:: !Bool
	,	gba_i_id					:: !Int
	,	gba_i_block_i				:: !Int
	,	gba_i_dynamic_rts_string	:: !String
	}
	
instance DefaultElem GetBlockAddress_In
where
	default_elem
		= {
			gba_i_filename				= default_elem
		,	gba_i_first_time			= default_elem
		,	gba_i_id					= default_elem
		,	gba_i_block_i				= default_elem
		,	gba_i_dynamic_rts_string	= default_elem
		}
	
:: GetBlockAddress_Out	
	= {
		gba_o_diskid_to_runtimeid			:: !{#Int}
	,	gba_o_disk_to_rt_dynamic_indices	:: !{#Int}
	,	gba_o_id							:: !Int
	,	gba_o_addresses						:: !String
	,	gba_o_rt_type_redirection_table		:: !{#RunTimeIDW}
	}
	
instance EnDecode GetBlockAddress_Out
where
	to_size {gba_o_diskid_to_runtimeid,gba_o_disk_to_rt_dynamic_indices,gba_o_id,gba_o_addresses,gba_o_rt_type_redirection_table}
		= to_size gba_o_diskid_to_runtimeid 
		+ to_size gba_o_disk_to_rt_dynamic_indices
		+ to_size gba_o_id
		+ to_size gba_o_addresses
		+ to_size gba_o_rt_type_redirection_table

	to_string {gba_o_diskid_to_runtimeid,gba_o_disk_to_rt_dynamic_indices,gba_o_id,gba_o_addresses,gba_o_rt_type_redirection_table} offset buffer
		# (offset,buffer)
			= to_string gba_o_diskid_to_runtimeid offset buffer
		# (offset,buffer)
			= to_string gba_o_disk_to_rt_dynamic_indices offset buffer
		# (offset,buffer)
			= to_string gba_o_id offset buffer
		# (offset,buffer)
			= to_string gba_o_addresses offset buffer
		# (offset,buffer)
			= to_string gba_o_rt_type_redirection_table offset buffer
		= (offset,buffer)

	from_string offset buffer
		#! (gba_o_diskid_to_runtimeid,offset)
			= from_string offset buffer
		#! (gba_o_disk_to_rt_dynamic_indices,offset)
			= from_string offset buffer
		#! (gba_o_id,offset)
			= from_string offset buffer
		#! (gba_o_addresses,offset)
			= from_string offset buffer
		#! (gba_o_rt_type_redirection_table,offset)
			= from_string offset buffer
			
		#! di
			= { default_elem &
				gba_o_diskid_to_runtimeid			= gba_o_diskid_to_runtimeid
			,	gba_o_disk_to_rt_dynamic_indices	= gba_o_disk_to_rt_dynamic_indices
			,	gba_o_id							= gba_o_id
			,	gba_o_addresses						= gba_o_addresses
			,	gba_o_rt_type_redirection_table		= gba_o_rt_type_redirection_table
			}
		= (di,offset)	
	
instance DefaultElem GetBlockAddress_Out
where 
	default_elem
		= {
			gba_o_diskid_to_runtimeid			= default_elem
		,	gba_o_disk_to_rt_dynamic_indices	= default_elem
		,	gba_o_id							= default_elem
		,	gba_o_addresses						= default_elem
		,	gba_o_rt_type_redirection_table		= default_elem
		}
		
GetBlockAddresses2 :: !GetBlockAddress_In -> (a,!GetBlockAddress_Out)
GetBlockAddresses2 {gba_i_filename,gba_i_first_time,gba_i_id,gba_i_block_i,gba_i_dynamic_rts_string}
	// do request
	#! msg
		= "Compute2DescAddressTable" +++ gba_i_filename +++
			"\n" +++ toString gba_i_first_time +++
			"\n" +++ toString gba_i_id +++ 
			"\n" +++ toString gba_i_block_i +++
			
			(if (gba_i_first_time && (size gba_i_dynamic_rts_string <> 0))
				("\n" +++ gba_i_dynamic_rts_string +++ "\n")
			
				"\n")
	#! s_adr
		= doreqS msg

	#! gba_o
		= case gba_i_first_time of
			True
				# (gba_o=:{gba_o_addresses})
					= decode s_adr
			

/*
//WERKT!
				#! (diskid_to_runtimeid,j)
					= from_string 0 s_adr
				#! (di_disk_to_rt_dynamic_indices,j2)  // j)
					= from_string j s_adr
					
				#! (id,j)
					= from_string j2 s_adr
				#! (rt_type_redirection_table,j)
					= ({},j) // from_string j s_adr
				#! s_adr
					= s_adr % (j2,dec (size s_adr))

				#! gba_o
					= { 
						gba_o_diskid_to_runtimeid			= diskid_to_runtimeid
					,	gba_o_disk_to_rt_dynamic_indices	= di_disk_to_rt_dynamic_indices
					,	gba_o_id							= id
					,	gba_o_addresses						= s_adr
					,	gba_o_rt_type_redirection_table		= rt_type_redirection_table //{}
					}
*/
				-> gba_o
			False
				#! gba_o
					= { default_elem &
						gba_o_id							= gba_i_id
					,	gba_o_addresses						= s_adr
					}
				-> gba_o
				
//	| True
//		= abort (toString (FromStringToInt gba_o.gba_o_addresses 0) +++ " , " +++ toString (size gba_o.gba_o_addresses));
		
	# (ok,copy_string_to_graph)
		= read_function ((FromStringToInt gba_o.gba_o_addresses 4 )) //4))
	= (copy_string_to_graph,gba_o)
	
// -------------------------------------------------------------------------------------------
:: *GetDynamicRTSInfo_In
	= {
		gdri_i_type_library_instances		:: !*{#Int}
	,	gdri_i_lazy_dynamics_references		:: !{#LazyDynamicReference}
	,	gdri_i_runtime_ids					:: !{#RunTimeIDW}
	}
	
/*
// A lazy dynamic reference is generated by the graph_to_string conversion routine.
:: LazyDynamicReference
	= { 
		ldr_id							:: !Int			// run-time id of lazy dynamic
	,	ldr_site						:: !String		// e.g. path to dynamic
	,	ldr_lazy_dynamic_index			:: !Int			// disk id for lazy dynamic (block)
	}
	
instance DefaultElem LazyDynamicReference
where
	default_elem 
		= { 
			ldr_id					= default_elem
		,	ldr_site				= default_elem
		,	ldr_lazy_dynamic_index	= default_elem
		}

instance EnDecode LazyDynamicReference
where
	to_size {ldr_id,ldr_site,ldr_lazy_dynamic_index}
		= to_size ldr_id + to_size ldr_site + to_size ldr_lazy_dynamic_index
		
	to_string {ldr_id,ldr_site,ldr_lazy_dynamic_index} offset buffer
		# (offset,buffer)
			= to_string ldr_id offset buffer
		# (offset,buffer)
			= to_string ldr_site offset buffer
		# (offset,buffer)
			= to_string ldr_lazy_dynamic_index offset buffer
		= (offset,buffer)
			
	from_string offset buffer
		# (ldr_id,offset)
			= from_string offset buffer
		# (ldr_site,offset)
			= from_string offset buffer
		# (ldr_lazy_dynamic_index,offset)
			= from_string offset buffer
			
		# lazy_dynamic_reference
			= { 
				ldr_id 					= ldr_id
			,	ldr_site				= ldr_site
			,	ldr_lazy_dynamic_index	= ldr_lazy_dynamic_index
			}
		= (lazy_dynamic_reference,offset)
*/
// changed also graph_to_string.c; CONVERT_LAZY_RUN_TIME_ID
:: RunTimeIDW
	= {
		rtid_type_string		:: !String
	,	rtid_runtime_id			:: !Int
	,	rtid_assigned_disk_id	:: !Int			// id reference from type
	}
	
instance EnDecode RunTimeIDW
where
	to_size {rtid_type_string,rtid_runtime_id,rtid_assigned_disk_id}
		= to_size rtid_type_string + to_size rtid_runtime_id + to_size rtid_assigned_disk_id

	to_string {rtid_type_string,rtid_runtime_id,rtid_assigned_disk_id} offset buffer
		# (offset,buffer)
			= to_string rtid_type_string offset buffer
		# (offset,buffer)
			= to_string rtid_runtime_id offset buffer
		# (offset,buffer)
			= to_string rtid_assigned_disk_id offset buffer
		= (offset,buffer)

	from_string offset buffer
		#! (rtid_type_string,offset)
			= from_string offset buffer
		#! (rtid_runtime_id,offset)
			= from_string offset buffer
		#! (rtid_assigned_disk_id,offset)
			= from_string offset buffer
			
		#! di
			= { default_elem &
				rtid_type_string		= rtid_type_string
			,	rtid_runtime_id			= rtid_runtime_id
			,	rtid_assigned_disk_id	= rtid_assigned_disk_id
			}
		= (di,offset)	
				 
instance DefaultElem RunTimeIDW
where
	default_elem
		= {
			rtid_type_string		= ""
		,	rtid_runtime_id			= default_elem
		,	rtid_assigned_disk_id	= 0
		}

GetDynamicRTSInfo :: !GetDynamicRTSInfo_In -> *{#Char}
GetDynamicRTSInfo {gdri_i_type_library_instances,gdri_i_lazy_dynamics_references,gdri_i_runtime_ids}
	#! dynamic_rts_info
		= doreqS ("GetDynamicRTSInfo" +++ 
			encode gdri_i_type_library_instances
		+++ encode gdri_i_lazy_dynamics_references
		+++ encode gdri_i_runtime_ids)
	= dynamic_rts_info
	
// -------------------------------------------------------------------------------------------	
:: GetGraphToStringFunction_Out
	= {
		ggtsf_o_n_library_instances		:: !Int
	,	ggtsf_o_range_table				:: !String
	}

copy_graph_to_string2
	=: doreqS ("GetGraphToStringFunction")
copy_graph_to_string_addr
	=: FromStringToInt copy_graph_to_string2 0
	
GetGraphToStringFunction :: (a,GetGraphToStringFunction_Out)
GetGraphToStringFunction
	# (_,copy_graph_to_string)
		= read_function ((FromStringToInt copy_graph_to_string2 0))
		
	# n_bytes_to_skip
		= 4

	# ggtsf
		= {
			ggtsf_o_n_library_instances		= FromStringToInt copy_graph_to_string2 (n_bytes_to_skip + RID_N_TYPE_TABLES_OFFSET)
		,	ggtsf_o_range_table				= copy_graph_to_string2 % (n_bytes_to_skip,dec (size copy_graph_to_string2))
		}
	= (copy_graph_to_string,ggtsf)

read_function :: !Int -> (!Bool,a)
read_function _ =
	code {
		jmp read_function
	}

doreqS :: !String -> .{#Char}
doreqS _ =
	code { 
		ccall DoReqS "S-S"
	}

// -------------------------------------------------------------------------------------------	
:: *OpenDynamicToLinker_Out
	= {
		odtl_o_ok					:: !Bool
	,	odtl_o_file 				:: !*(!Int,!*StdDynamicSharedBufferInfo)
	,	odtl_o_dynamic_rts_string	:: !String
	}	
		
OpenDynamicToLinker :: !String -> *OpenDynamicToLinker_Out
OpenDynamicToLinker dynamic_as_string
	# (ok,file,dynamic_rts_string)
		= CreateSharedBufferFromPageFile GetHandleToServer dynamic_as_string
	# odtl_o
		= {
			odtl_o_ok					= ok
		,	odtl_o_file 				= file
		,	odtl_o_dynamic_rts_string	= dynamic_rts_string
		}
	= odtl_o
where
	// LowLevel-interface
	GetHandleToServer :: HANDLE
	GetHandleToServer 
		= code {
			ccall GetHandleToServer ":I"
		}
		
CloseDynamicToLinker :: *OpenDynamicToLinker_Out -> Bool
CloseDynamicToLinker {odtl_o_file}
	| CloseSharedBufferFromPageFile odtl_o_file
		= True
		= False
		
// -------------------------------------------------------------------------------------------			
compare_type_name :: !(!String,.T_ypeID) !(!String,.T_ypeID) [TypeReference] -> (!Bool,[TypeReference])
compare_type_name (type_name1,type_id1) (type_name2,type_id2) type_refs
	// function type constructor
	| type_name1 == " -> " && type_name2 == type_name1
		= (True,type_refs)

		// other type constructors
		# (equal,type_name,module_name1,module_name2)
			= compare_type_name 0 (min s_type_name1 s_type_name2)
		| equal
			# type_ref
				= create_type_ref type_name type_id1 type_id2 module_name1 module_name2
			= (True,[type_ref:type_refs])
			= (False,type_refs)
where 
	compare_type_name i limit
		| i == limit
			= abort ("_SystemDynamic; type name without defining module <" +++ type_name1 +++ "> - <" +++ type_name2 +++ ">")
		| type_name1.[i] == '\''
			= (True,type_name1 % (0,dec i),type_name1 % (inc i,dec s_type_name1),type_name2 % (inc i,dec s_type_name2))
			
		| type_name1.[i] == type_name2.[i]
			= compare_type_name (inc i) limit
			
			= (False,"","","")
			
	s_type_name1 = size type_name1
	s_type_name2 = size type_name2
	
	create_type_ref type_name type_id1 type_id2 module_name1 module_name2
		# type_ref
			= { TypeReference |
				tr_type_name	= type_name
			,	tr_module_name1	= module_name1 
			,	tr_module_name2	= module_name2
			,	tr_library1		= determine_library_id type_id1
			,	tr_library2		= determine_library_id type_id2
			}
		= type_ref
	where
		determine_library_id (RunTimeID rt_id)
			= Number rt_id
		determine_library_id (ModuleID module_id)
			# (module_name,address)
				= get_module_id module_id
			= Address address
	
GetDynamicLinkerPath :: String;
GetDynamicLinkerPath
	=: doreqS ("GetDynamicLinkerDir\n");
	
CleanNewKey :: !String !String -> Bool;
CleanNewKey _ _
	= code {
		ccall CleanNewKey "SS:I"
	};
/*
	#! msg
		= doreqS ("GetDynamicLinkerDir\n");
	| msg <> msg
		= abort "GetDynamicLinkerPath: (internal error)";
	= msg;
*/
		
// -------------------------------------------------------------------------------------------			
SendEncodedDynamic :: !EncodedDynamic !String -> String;
SendEncodedDynamic encoded_dynamic file_name
	= abort "SendEncodedDynamic";
	